package jp.mosp.common;

public class ExportInfoUtility {

	/**
	 * l擾pz
	 */
	protected String[] aryKihonItem;

	/**
	 * Αӏ񍀖ڗpz
	 */
	protected String[] aryKintaiItem;

	/**
	 * oΕ񍀖ڗpz
	 */
	protected String[] arySyukkinItem;

	/**
	 * Lxɏ񍀖ڗpz
	 */
	protected String[] aryYukyuItem;

	/**
	 * RXgN^
	 */
	public ExportInfoUtility() {

	}

	/**
	 * RXgN^()
	 * @param aryKihonItem			l擾pz
	 * @param aryKintaiItem			Αӏ񍀖ڗpz
	 * @param arySyukkinItem		oΕ񍀖ڗpz
	 * @param aryYukyuItem			Lxɏ񍀖ڗpz
	 */
	public ExportInfoUtility(
			String[] aryKihonItem,
			String[] aryKintaiItem,
			String[] arySyukkinItem,
			String[] aryYukyuItem
	) {
		init(aryKihonItem, aryKintaiItem, arySyukkinItem, aryYukyuItem);
	}

	/**
	 * 
	 * @param aryKihonItem			l擾pz
	 * @param aryKintaiItem			Αӏ񍀖ڗpz
	 * @param arySyukkinItem		oΕ񍀖ڗpz
	 * @param aryYukyuItem			Lxɏ񍀖ڗpz
	 */
	public void init(
			String[] aryKihonItem,
			String[] aryKintaiItem,
			String[] arySyukkinItem,
			String[] aryYukyuItem
	) {
		this.aryKihonItem 		= aryKihonItem.clone();
		this.aryKintaiItem 		= aryKintaiItem.clone();
		this.arySyukkinItem 	= arySyukkinItem.clone();
		this.aryYukyuItem 		= aryYukyuItem.clone();
	}

	/**
	 * GNX|[g񍀖ڐݒ
	 * @param strFLID	Ώۃe[uR[h
	 * @return	String[][]	GNX|[g񍀖ڔz
	 * @throws Exception
	 */
	public String[][] getKintaiDataItem(String strFLID) throws Exception {
		int ItemLength = aryKihonItem.length;
		if (strFLID.equals(CommonConst.CODE_TABLE_M_KINTAI)) {
			ItemLength += aryKintaiItem.length;
		}
		if (strFLID.equals(CommonConst.CODE_TABLE_M_SYUKKINBO)) {
			ItemLength += arySyukkinItem.length;
		}
		if (strFLID.equals(CommonConst.CODE_TABLE_M_YUKYU)) {
			ItemLength += aryYukyuItem.length;
		}
		int i = 0;
		String[][] aryItem = new String[ItemLength][2];
		// l擾pz
		for (i = 0; i < aryKihonItem.length; i++) {
			aryItem[i][0] = aryKihonItem[i];
			aryItem[i][1] = spritInfo(aryKihonItem[i], 3);
		}
		// Αӏ񍀖ڗpz
		int j = i;
		if (strFLID.equals(CommonConst.CODE_TABLE_M_KINTAI)) {
			for (i = 0; i < aryKintaiItem.length; i++) {
				aryItem[j+i][0] = aryKintaiItem[i];
				aryItem[j+i][1] = spritInfo(aryKintaiItem[i], 3);
			}
		}
		// oΕ񍀖ڗpz
		if (strFLID.equals(CommonConst.CODE_TABLE_M_SYUKKINBO)) {
			for (i = 0; i < arySyukkinItem.length; i++) {
				aryItem[j+i][0] = arySyukkinItem[i];
				aryItem[j+i][1] = spritInfo(arySyukkinItem[i], 3);
			}
		}
		// Lxɏ񍀖ڗpz
		if (strFLID.equals(CommonConst.CODE_TABLE_M_YUKYU)) {
			for (i = 0; i < aryYukyuItem.length; i++) {
				aryItem[j+i][0] = aryYukyuItem[i];
				aryItem[j+i][1] = spritInfo(aryYukyuItem[i], 3);
			}
		}
		return aryItem;
	}

	/**
	 * tB[h̓̃f[^擾
	 *  0 : t@CID
	 *  1 : Ǘԍ
	 *  2 : tB[hID
	 *  3 : tB[h
	 */
	protected String spritInfo(String str, int i) {
		//@Ǘԍ擾
		if  (str.length()!= 0)  {
			String[] array;
			array = str.split(CommonConst.STR_CSV_SEPARATOR);
			return array[i];
		}
		return "";
	}

}
